type = "L";   // ["L"]
size = 25;
// Defaults to size/4
width=0;
// Defaults to size/6
height=0;
numHoles = 3;
// Defaults to width/2
holeSize=0;   // 0.1

// Optional hole in corner
cornerHole = true;

module __stop() {};


if (type == "L") {
  lAngle();
}


module lAngle() {
  cWidth = (width==0)? size/4: width;
  cHeight = (height==0)? size/6 : height;
  difference() {
    union() {
      translate([size/2-cWidth,-cWidth/2,0])
        cube([size, cWidth, cHeight],center=true);

      translate([-cWidth/2,size/2-cWidth,0])
        rotate([0,0,90])
          cube([size, cWidth, cHeight],center=true);
    }
    // Inside corner hole
    cylinder(d=size/10,h=cHeight*1.1,center=true,$fn=100);
    // Hole size default or overridden
    hSize = (holeSize==0)? cWidth/2 : holeSize;
    // Hole in corner
    if (cornerHole) {
      translate([-cWidth/2, -cWidth/2,0])
        cylinder(d=hSize,h=cHeight*1.1,center=true,$fn=100);
    }
    
    // Outside corner bevel
    translate([-cWidth*1.2,-cWidth*1.2,0])
      rotate([0,0,45])
       cube([cWidth,cWidth*2,cHeight*1.1],center=true);

    // Clamp holes
    sl = size - cWidth;   // Length of side
    sp = sl / numHoles;
    for (h=[0:1:numHoles-1]) {
      translate([sl - sp/2 - sp * h, -cWidth/2,0])
        cylinder(d=hSize,h=cHeight*1.1,center=true,$fn=100);
      translate([-cWidth/2,sl - sp/2 - (sp * h),0])
        cylinder(d=hSize,h=cHeight*1.1,center=true,$fn=100);
    }
  } 
}