scale="10mm";   // [10mm,1/32,O,mm]
//  Distance to C/L rail from base
standOffInches=5;       // [0.0:0.1:24.0]
knobDia=2.2;            // [1.0:0.1:5.0]
knobWidthPercent=80;    // [20:1:100]
handrailDia=0.75;
// Array of stanchons or single?
build="array"; // [single,array]
// Type of single stanchion
location="middle"; // [middle,end,90deg,vTee]

module __stopCustomizer() {}

sf=25.4/(scale=="10mm"?30.6:scale=="1/32"?32:scale=="mm"?25.4:43.5);
$fn=80;

// Marker useful for loccating a particular spot  
//translate([0,0,5.0*sf]) color("red") sphere(0.5);

hkdata=[
    "handrail",
    "stanchion",
    [         // Configuration depends on type
      handrailDia*sf,               // 0: Handrail diameter
      [                     // 1: 
        knobDia*sf,             // 0: Main knob dimensions
        knobDia*sf*(knobWidthPercent/100),// 1: Knob width
      ],
      standOffInches*sf,               // 2: Standoff distance
      [1.2*sf,2.0*sf],      // 3: Main stem diameters
      [1.5*sf,2.5*sf],      // 4: Fixing pin diameter and length
      [                     // 5: Base
        3.0*sf,             //   0: Base diameter (Not including fillet)
        0.5*sf,             //   1: Base height
        0.25*sf,            //   2: Fillet radius
      ],
    ],
    [   
      [
        "stanchions",
        [
          ["end",[0,0,0],[0,0,-90]],
          ["middle",[12.*sf,0,0],[0,0,90]],
          ["middle",[24.*sf,0,0],[0,0,90]],
          //["vTee",[24.0*sf,0,0],[0,0,90]],
          ["90deg", [36.0*sf,0,0],[0,0,90]],
          ["middle",[36.0*sf,15*sf,0],[0,0,0]],
          ["middle",[36.0*sf,30*sf,0],[0,0,0]],
          ["end",[36*sf,45*sf,0],[0,0,180]],
          ["middle",[24.*sf,45*sf,0],[0,0,90]],
          ["middle",[12.*sf,45*sf,0],[0,0,90]],
          ["end",[0,45*sf,0],[0,0,-90]],
        ],
      ],
      [
        "bars",
        [
          ["cylinder",[36.0*sf,handrailDia*sf],[18.0*sf,0,standOffInches*sf],[0,90,0]],
          ["cylinder",[45.0*sf,handrailDia*sf],[36.0*sf,22.5*sf,standOffInches*sf],[0,90,90]],
//          ["cylinder",[standOffInches*sf,handrailDia*sf],[24.0*sf,0,standOffInches*sf/2],[0,0,0]],
          ["cylinder",[36.0*sf,handrailDia*sf],[18.0*sf,45*sf,standOffInches*sf],[0,90,0]],
        ],
      ],
    ],
];


if (build=="single") {
  handrailStanchion(hkdata[2],location);
} else {
  handrails(hkdata);
}
  
module handrails(config) {
  for (items= config[3]) {
    type=items[0];
    if (type=="stanchions") {
      for (place=items[1]) {
        translate(place[1])
          rotate(is_undef(place[2])?[0,0,0]:place[2])
            handrailStanchion(config[2],place[0]);
      }
    } else if (type=="bars") {
      for (place=items[1]) {
        bType=place[0];
        translate(place[2]) {
          rotate(is_undef(place[3])?[0,0,0]:place[3]) {
            if (bType=="cylinder") {
              cylinder(h=place[1][0],d=place[1][1],center=true);
            }
          }
        }
      }
    }
  }  
}

module handrailStanchion(config,type="middle") {
  kdia=config[1][0];
  sdia2=config[3][1];
  fr=is_undef(config[5][2])?0:config[5][2];   // Fillet radius
  bh=config[5][1]+fr;                         // Base height
  bd=config[5][0];
  
  // The knob and main stem (ensure hole in it)
  rotate([180,0,0]){
    translate([0,0,-config[2]]) {
      difference() {
        union() {
          sphere(d=kdia);
          // The stem
          if (type[0] != "v") {
            sl=config[2];
            translate([0,0,0])
              cylinder(h=sl-bh,d1=config[3][0],d2=sdia2);
          }
        }
        rotate([90,0,0])
          translate([0,0,type=="middle"?0:kdia])
            cylinder(h=kdia*2,d=config[0],center=true);
        translate([0,-(kdia+config[1][1])/2])
          cube([kdia,kdia,kdia],center=true);
        if (type=="middle" || type=="vTee") {
          translate([0,+(kdia+config[1][1])/2])
            cube([kdia,kdia,kdia],center=true);
        }        
        if (type=="90deg") {
          rotate([90,0,90])
            translate([0,0,type=="middle"?0:kdia])
              cylinder(h=kdia*2,d=config[0],center=true);
          translate([(kdia+config[1][1])/2,0,0])
            cube([kdia,kdia,kdia],center=true);
        } else if (type[0]=="v") {
          translate([0,0,type=="vTee"?kdia:0])
            cylinder(h=kdia*2,d=config[0],center=true);
          translate([0,0,(kdia+config[1][1])/2])
            cube([kdia,kdia,kdia],center=true);
        }
        
      }
    }
    if (type[0] != "v") {
      // Fixing pin 
      if (is_list(config[4])) {
        cylinder(h=config[4][1],d=config[4][0]);
      }
      // Finally a base?
      if (!is_undef(config[5])) {
        fdia=sdia2+config[5][2]*2;
        translate([0,0,-bh])
        difference() {
          cylinder(h=bh,d=bd);
          blockDoughnut(d=fdia,t=fr*2,d2=bd*1.1);
        }
      }
    }
  }
}

/** Creates a doughnut shape within a block (or part of)
 * Can be used for creating round fillet masks
 * d: diameter of center of doughnut
 * t: thickness of doughnut
 * a: (optional) andgle of part of doughnut (360 by default)
 */
module blockDoughnut(d,t,d2=0,a=360) {
  assert(d2==0 || d2>=d,"blockDoughnut: Unworkable parameters- d2 must be 0 or >= d");
  rotate_extrude(angle=a) {
    bd=d2==0?t/2:t/2+(d2-d)/2;
    translate([d/2,0]) {
     circle(d=t);
     translate([bd/2,0])
       square([bd,t],center=true);
    }
  }
}
