/**
 * Copyright (C) 2025. Donald Pickett All rights reserved
 * Provided as part the Gauge 1 3D Circle
 * License: Creative Common Attribution-NonCommercial-ShareAlike CC BY-NC-SA 4.0 International
 *          See: https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode.en
 * Version 1.4 21/10/2025
 *  Hub dia can now be specified as scaled inches or absolute mm
 *  Tabs tidied
 *  Scale adjustment added to Customizer panel
 *  Bug with scaling chamfers fixed
 * Version 1.3 20/07/2025
 *  Tweaks to Chaldron wheel
 * Version 1.2 11/01/2025
 *  Added split spoke type 
 *  Added ability to change number and size of holes in wheels.
 * Version 1.1 03/01/2025
 *  Added RCH 3 hole pressed steel wheel
 *  Minor code changes and tidy ups.
 * Version 1.0 03/01/2025
 *  Initial release version
 */
// Select the scale you want (Not all scales currently supported)
scale="1/32";     // [1,10mm,1/32,O,OO,3.5in,5in]
 
wheelType="spoked";   // [mk1Coach,mansell,solid,chaldron,nHole,spoked,rchSpoked,rchHole]
wheelStandard="fine";   // [standard,fine]
/* [Values as appropriate] */
spokeType="flat";       // [flat,round,split]
numSpokes=8;
numHoles=4;
/* [Inch dimensions - scaled] */
wheelSize=37.5;         // .5
// Spoke size in inches
spokeSize=1.5;
// 0.0 - Use actual mm diameter
hubDiaIn=0.0;             // .1
/* [mm dimensions - NOT scaled] */
hubDia=9.0;             // .1
holeDia=6.0;            // .1
// The hub depth defaults to the wheel rim depth. This value will be added to the outside of the wheel hub
hubDepthAddition=0;     // .05
axleDia=3.0;            //  .1

/* [Hidden] */
module __stop() {}      // Hidden above was allowing the value _dx=0.1 to show in the configurator!

buildWheel=true;

$fn=$preview?100:200;

g132sf=25.4/32;
g110mmsf=25.4/30.6;
Ogsf=25.4/43.5;

include <wheels-v1.4.scad>
include <g1Shapes.scad>

sf=scale=="10mm"?g110mmsf
  :scale=="1/32"?g132sf
  :scale=="O"?Ogsf
  :scale=="OO"?25.4/76.2
  :scale=="3.5in"?25.4/16
  :scale=="5in"?25.4/11.2941
  :1; //                          g132sf;          // 1/32 scale - Gauge 1.

//sf=25.4/16;         // 3.5" gauge
//sf=g110mmsf;        // 10mm foot - Gauge 1.
//sf=g132sf;          // 1/32 scale - Gauge 1. == 9.525mm/ft
//sf=Ogsf;            // O gauge scale (British) 7mm/ft
//sf=25.4/48;         // O gauge American
//sf=25.4/72;         // Model "scale"
//sf=25.4/76.2;       // OO "scale"
//sf=25.4/120;        // TT "scale"
//sf=25.4/148;        // N scale
//sf=25.4/220;        // Z scale
//sf=25.4/300;        // ZZ scale
//sf=25.4/450;        // T scale
//sf=25.4/480;        // T scale or is it 1/480?
//sf=1;                 // 1/25.4 =?> 1mm = 1inch

_dx=0.01;   // Adjustment to force adjacent parts join

_embedDepth=0.5*sf;             // Default value for object such as handles to be buried into side they are attached to
standard=wheelStandard();

if (buildWheel) {
  spokeConfig=[numSpokes,spokeType,spokeSize];
  holeConfig=[numHoles,holeDia];
  railWheel(
    standard=standard,
    type=wheelType,
    dia=wheelSize*sf,
    axleDia=axleDia,
    hubDia=hubDiaIn<0.01?hubDia:hubDiaIn*sf,
    hubDelta=hubDepthAddition,
    spokeConfig,
    holeConfig
  );
}  else splitSpoke(10);

// You can override any module in the include files after they are included.
// For example for a solid wheen with a flat back and 1" scale indent on front
// override the default solid wheel hub
/**
  * ***WheekHub() Draw Differens wheel hubs from the centre to the wheel rim
  * Builds a complete railway wheel.
  * Parameters:
  *   config:: array
  *     0  : diameter (dai) - mms. Diameter of whole hub (Inside rim)
  *     1  : rim width - mm. The width of the wheel rim defind by standard
  *     2  : hubDia - mm. Centre hub diameter: 
  *     3  : hubWidth - mm. default 0. Width of hub Defaults to rim width
  *     4  : axle diameter - mmd. The diameter of the axle (Hole in middle
  *
 */    
/*
module solidWheelHub(config=[36.0*sf,5.0]) {
  dia=config[0];
  rw=config[1];
  hubDia=is_undef(config[2])?10.0*sf:config[2];
  hubWidth=is_undef(config[3])?10.0*sf:config[3];

  union() {
    cylinder(h=rw-(1.0*sf),d=dia);
    cylinder(h=hubWidth,d=hubDia);
  }
}
*/

