/* AG1LE flexible sheet generator
   
   Copyright (C) 2020 by Adrian Johnstone <a.johnstone@rhul.ac.uk>

Permission to use, copy, modify, and/or distribute this software for any purpose
with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

*/

/* User accessible paramaters whichmay be set using the OpenSCAD customiser */

sheetX = 200; // External x
sheetY = 84;  // External y
sheetZ = 1.6; // Sheet thickness

borderX = 4.5; // Width of the border on each side
borderY = 3.5; // Width of top and bottom border

repeatX = 8; // Number of horizontal
repeatY = 45; // Number of vertical segments

gapX = 1; // horizontal connecting bar width
gapY = 1; // vertical connecting bar height

module flexiblePanel() {
/* sheetX = 2 * borderX + repeatX * slotX + (repeatX-1) * gapX
    hence slotX = (sheetX - 2* borderX - (repeatX - 1) * gapX)/repeatX, and symmetrically for slotY
*/

  slotX = (sheetX - 2* borderX - (repeatX - 1) * gapX)/repeatX ; 
  slotY = (sheetY - 2* borderY - (repeatY - 1) * gapY)/repeatY ; 


  difference() {
    cube([sheetX, sheetY, sheetZ]);
    intersection() {
      translate([borderX, borderY,-5]) cube([sheetX-2*borderX, sheetY-2*borderY, 10]);
      translate([borderX, borderY, 0]) for (x = [0:repeatX]) {
        for (y = [0:repeatY-1]) {
          offset = - (y % 2) * (slotX + gapX)/2;
          translate([offset + x * (slotX + gapX ), y * (slotY + gapY), -5]) cube([slotX, slotY, 10]);
        }
      }
    }
  }
}

flexiblePanel();